#!/usr/bin/perl -w
# copyright(c)2018-2019 Kumeuchi Akira
use strict;
use utf8;
use CGI;
use URI::Escape;
use File::Basename;
use File::Copy;
use File::Path;
use Encode;
use FindBin;
use Image::Magick;
use Archive::Zip;
use Try::Tiny;
binmode STDOUT, ':utf8';

# setting.
my $imgsize = 120;
my $elapsedtime = 0.5;
my $err = "";
my $bodyMsg = "";
my $listWidth = 240;
my $listHeight = 20;

# initialzation.
my $q = new CGI;
my $file = "";
my @files = ();
my $dir = "";
my @dirs = ();
my $out = "";
my $fullpath = decode('UTF-8', uri_unescape($FindBin::Bin));

# get display mode
my $displayMode = 2;
$displayMode = $q->param('d') or $displayMode = 2;

# handy functions.
sub printenc($){
	print($_ . "\n");
}

sub GetParams(){
	if(!defined($_) or $_ eq ""){
		$err .= "配列が定義されていません。\n";
		return;
	}
	my $item = $_;
	chomp($item);
	my @items = split(":", $item);
	return(@items);
}

# subroutines.
sub GetLinkedTag($$){
	my($file, $ext) = @_;
	my $escfile = uri_escape_utf8($file);
	if($file eq ""){
		return "";
	}
	my $checkbox = "<input type = \"checkbox\" name = \"cb[]\" value = \"$file\" />";
	if($ext =~ /\.(cgi|pl|php|exe|bat)/){
		return("$checkbox$file");
	}
	else{
		return("$checkbox<a href = \"$escfile\">$file</a>");
	}
}

sub GetIconTag($$){
	my($file, $ext) = @_;
	$file = uri_unescape($file);
	my $ret = "";
	my $thumbnail = ".$file.png";
	if($ext =~ /\.(gif|jpe?g|png)/){
		if(!(-f $thumbnail) or ((-M $thumbnail) > $elapsedtime)){
			my $image = Image::Magick->new;
			$image->Read("$file");
			$image->Resize($imgsize);
			$image->Write($thumbnail);
			undef($image);
		}
		$ret = "<div class = \"img\"><a href = \"$file\"><img src = \"$thumbnail\" class = \"img\" /></a></div>";
	}
	elsif($ext =~ /\.(cgi|pl|php|exe|bat)/){
		$ret = "<div class = \"misc\">$ext</div>";
	}
	else{
		$ret = "<div class = \"misc\"><a href = \"$file\">$ext</a></div>";
	}
	return($ret);
}

sub GetListTag($$){
	my($file, $ext) = @_;
	my $ret = "<li>" . GetLinkedTag($file, $ext) . "</li>";
	return($ret);
}
	

sub GetItem($$){
	my($file, $ext) = @_;
	my $ret = "<div class = \"item\">" . GetIconTag($file, $ext) . GetLinkedTag($file, $ext) . "</div>\n";
	return($ret);
}

# upload files (multiple)
sub UploadFiles(){
	my @files = $q->param('upload');
	foreach my $file(@files){
		my $tmp = $q->tmpFileName($file);
		$file = basename($file);
		my $path = ".";
		my $newfile = "$path/$file";
		if (!copy($tmp, $newfile)){
			$bodyMsg .= decode('UTF-8', "Error while updating $file : $!<br />");
		}
		$bodyMsg .= decode('UTF-8', $file) . " Uploaded<br />";
	}
}

# drag & drop files
sub DNDFiles(){
	my $fp = $q->upload('uploads');
	my @fnames = $q->param('uploads');
	foreach my $fname(@fnames){
		$fname = basename($fname);
		copy($fp, "./$fname");
	}
}	

# create new directory (new directory name)
sub NewDirectory(){
	my $directory = $q->param("status");
	#$dir = decode('UTF-8', basename($dir));
	my $dir = basename($directory);
	if($dir ne ""){
		mkdir($dir);
		chmod 0777, $dir;
		if (!copy("./sfs.cgi", "$dir/")){
			$bodyMsg .= decode('UTF-8', "Error while creating directory named $directory : $!<br />");
		}
		chmod 0775, "$dir/sfs.cgi";
		if (!copy("./sfss.cgi", "$dir/")){
			$bodyMsg .= decode('UTF-8', "Error while creating directory named $directory : $!<br />");
		}
		chmod 0775, "$dir/sfss.cgi";
		$bodyMsg .= decode('UTF-8', $dir) . "ディレクトリを作成しました。<br />";
	}
}

# Rename file or directory
sub RenameFile(){
	my $temp = $q->param("status");
	my $oldfile;
	my $newfile;
	($oldfile, $newfile) = split(":", $temp);
	if($newfile eq ""){
		$bodyMsg .= "リネームするファイル名を入力してください。\n";
		return 0;
	}
	$oldfile = uri_unescape($oldfile);
	$newfile = uri_unescape(basename($newfile));
	rename($oldfile, $newfile);
	$bodyMsg .= decode('UTF-8', $oldfile) . " を "
		. decode('UTF-8', $newfile) . " にリネームしました。<br />";
}

# Delete file or directory
sub DeleteFile(){
	my $arg = $q->param('status');
	my @files = split(':', $arg);
	if(!exists($files[0])){
		$bodyMsg .= "ファイルが選択されていません。\n";
		exit;
	}
	foreach my $file(@files){
		$file = uri_unescape($file);
		if(-d $file){
			if(rmtree($file)){
				$bodyMsg .= decode('UTF-8', $file) . "を削除しました。<br />";
			}
			else{
				$bodyMsg .= decode('UTF-8', $file) . "を削除できませんでした。<br />";
			}
		}
		elsif(-f $file){
			if(unlink($file)){
				$bodyMsg .= decode('UTF-8', $file) . "を削除しました。<br />";
			}
			else{
				$bodyMsg .= decode('UTF-8', $file) . "を削除できませんでした。<br />";
			}
		}
		else{
			$bodyMsg .= decode('UTF-8', $file) . "は不明なファイルです。<br />";
		}
	}

}

# Download with ZIP file
sub ZipFile(){
	my $arg = $q->param('status');
	$bodyMsg .= $arg . "<br />";
	my @files = split(':', $arg);
	if(!exists($files[0])){
		$bodyMsg .= "ファイルが選択されていません。<br />";
		exit;
	}
	my $zip = Archive::Zip->new();
	foreach my $file(@files){
		$file = uri_unescape($file);
		$zip->addFile($file);
	}
	if($zip->writeToFileNamed('download.zip') == Archive::Zip::AZ_OK){
		open my $fh, "<download.zip" or die($!);
		binmode $fh;
		print "Content-Type: application/zip;\n";
		print "Content-Disposition: attachment; filename=download.zip\n\n";
		while(read $fh, my $buf, 1048576){
			print $buf;
		}
		close $fh;
		unlink 'download.zip';
		$bodyMsg .= "ダウンロード中です。<br />";
	}
	else{
		$bodyMsg .= "ダウンロードに失敗しました。<br />";
	}
}

# POST処理
if($q->request_method eq "POST"){
	my $submit = "";
	$submit = $q->param('submit') or $submit = "";
	if($submit eq 'upload'){
		UploadFiles();
	}
	elsif($submit eq "newdir"){
		NewDirectory();
	}
	elsif($submit eq "rename"){
		RenameFile();
	}
	elsif($submit eq "delete"){
		DeleteFile();
	}
	elsif($submit eq "download"){
		ZipFile();
	}
	elsif($submit eq "dndfiles"){
		DNDFiles();
	}
}
if(defined($q->param('uploads')) and $q->param('uploads') ne ""){
	DNDFiles();
}
# write header.
$out = <<"EOM";
Content-type: text/html

<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
		"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv = "Content-Type" content = "text/html; charset = utf-8" />
<title>SFS</title>
<meta name = "Author" content = "Kumeuchi Akira" />
<meta name = "keywords" content = "SFS" />
<meta http-equiv = "Content-Style-Type" content = "text/css" />
<link href = "https://www.bass-world.net/styles.css" rel = "stylesheet" type = "text/css" media = "screen,tv" />
<style type = "text/css">
h1{margin: 8px 0px;}
p{margin: 8px;
  padding: 0px;
}
body{
	background-color: #ffffff;
}
.img{width: ${imgsize}px;}
div.item{width: ${imgsize}px; float: left; margin: 12px;}
div.misc{width: ${imgsize}px; height: ${imgsize}px; font-size: 36px; border-style: solid; border-width: 1px; border-color: #000000;}
div.itemlist{width: ${listWidth}px; height: ${listHeight}px; float: left; text-align: left; margin: 4px; border: 1px solid #eeeeee; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;}
.work_area{width: 100%; height: 50px;}
th{font-weight: normal; text-align: right; padding-right: 8px;}
.ok{background-color: #ffffff;}
.ng{background-color: #ffcccc;}
#floater{
	position: fixed;
	width: 100%;
	left: 0px;
	bottom: 0px;
	background-color: #000000;
	color: #ffffff;
}
#curtain{
	position: fixed;
	width: 100%;
	bottom: 64px;
	left: 0px;
	background-color: #000000;
	color: #ffffff;
}

#curtain a:link,#curtain a:visited{
	color: #ffffff;
}

#statussection{
	position: fixed;
	width: 100%;
	bottom: 0px;
	left: 0px;
	color: #ffffff;
	background-color: #000000;
}

#topfloater{
	position: fixed;
	width: 100%;
	top: 0px;
	background-color: #000000;
	color: #ffffff;
}
#topfloater h2,#topfloater h2 a:link,#topfloater h2 a:visited{color: #ffffff;}
#main{
	margin: 96px 0px 100px 0px;
	width: 100%;
}
#main h2{
	margin: 4px 0px;
}
ul{
	margin: 0px;
	padding: 0px 16px;
}
EOM
print($out) or die($!);
$out = <<'EOM';
@media screen and (max-device-width:480px),screen and (max-width:480px){
	body{
		font-size: 2.5rem;
	}
	input[type=radio],input[type=checkbox]{
		font-size: 2.5rem;
		height: 30px;
		width: 30px;
	}
	div.itemlist{
		font-size: 1.4em;
		height: 1.6em;
		width: 95%;
	}
	div.item{
		font-sie: 1.4em;
	}
	#topfloater,#floater{
		position: static;
		margin: 0px;
		padding: 0px;
	}
	#floater,#floater input[type=button]{
		-webkit-appearance: none;
		font-size: 2.5rem;
		
	}
	#main{
		background-color: #ffffff;
	}
	#floater .btn{
		font-size: 2.5rem;
		height: 5rem;
		margin: 0.5rem;
	}
	#topfloater p{
		padding: 0px;
		margin: 0px;
	}
	#statussection{
		display: none;
	}
	#curtain{
		padding: 0px;
		margin: 0px;
		font-size: 1.8em;
		bottom: 0px;
	}
}
EOM
print($out) or die($!);
$out = <<'EOM';
</style>
<meta http-equiv = "Content-Script-Type" content = "text/javascript" />
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script type = "text/javascript">
function PageLoad(e){
	var dropFrame = document.getElementById('main');
	dropFrame.addEventListener('dragover', onDragOver, false);
	dropFrame.addEventListener('drop', onDrop, false);
}
function onDragOver(e){
	e.preventDefault();
}
function onDrop(e){
	e.stopPropagation();
	e.preventDefault();
	
	var files = e.dataTransfer.files;
	for(var i = 0; i < files.length; i++){
		dndFile(files[i]);
	}
}
function dndFile(file){
	var formData = new FormData();
	formData.append('uploads', file);
	$.ajax({
		async: true,
		type: 'POST',
		contentType: false,
		processData: false,
		url: 'sfs.cgi',
		data: formData,
		datatype: 'html'
	}).done(function(){});
}

function NewDirectory(){
	var ret = window.prompt("新しいディレクトリ名を入力してください。", "");
	if(ret == ""){
		return false;
	}
	var files = GetContentsByName();
	if(files.indexOf(ret) >= 0){
		alert("同名のディレクトリが既に存在します。");
		return false;
	}
	document.getElementById("status").value = ret;
	return true;
}

function RenameFile(){
	var ret = GetCheckedItems();
	if(ret != 1){
		alert("リネームするファイルを1つだけチェックしてください。");
		return false;
	}
	var newfilename = window.prompt("新しいファイル名を入力してください。", "");
	if(newfilename == ""){
		return false;
	}
	var files = GetContentsByName();
	if(files.indexOf(newfilename) >= 0){
		alert("リネームする名前のファイルが既に存在します。");
		return false;
	}
	document.getElementById("status").value += ":" + newfilename;
	return true;
}

function DeleteFile(){
	var ret = GetCheckedItems();
	if(ret < 1){
		alert("削除するファイルをチェックしてください。");
		return false;
	}
	var msg = ret + "個のファイルを削除していいですか?";
	var ok = confirm(msg);
	if(ok == false){
		return false;
	}
	return true;
}

function UploadFile(){
	var files = document.getElementByName('upload');
	alert('hoge');
	alert(files);
	document.getElementByName('uploads').value = files.join(':');
	return(files.length);
}

function DownloadFile(){
	var ret = GetCheckedItems();
	if(ret < 1){
		alert("ダウンロードするファイルをチェックしてください。");
		return false;
	}
	return true;
}

function GetCheckedItems(){
	eStatus = document.getElementById("status");
	var files = [];
	var e = document.getElementsByName('cb[]');
	for(var i = 0; i < e.length; i++){
		if(e[i].checked == true){
			//var str = e[i].value
			var str = encodeURI(e[i].value);
			files.push(str);
		}
	}
	eStatus.value = files.join(":");
	return(files.length);
}

function GetContentsByName(){
	var contents = "";
	var e = document.getElementsByName('cb[]');
	for(var i = 0; i < e.length; i++){
		contents += ":" + encodeURI(e[i].value);
	}
	return(contents);
}

function CurtainUp(){
	document.getElementById("statussection").style.display = "block";
	if(screen.width > 640){
		document.getElementById("curtain").style.bottom = "64px";
	}else{
		document.getElementById("curtain").style.bottom = "0px";
		document.getElementById("statussection").style.bottom = "108px";
	}
}

function CurtainDown(){
	document.getElementById("statussection").style.display = "none";
	document.getElementById("curtain").style.bottom = "0px";
}
</script>
</head>
EOM
print($out) or die($!);
my($rdoDisplayMode1, $rdoDisplayMode2);
if($displayMode eq 1){
	$rdoDisplayMode1 = "checked = \"checked\"";
	$rdoDisplayMode2 = "";
}
else{
	$rdoDisplayMode1 = "";
	$rdoDisplayMode2 = "checked = \"checked\"";
}
$out = <<'EOM';
<body>
<script type = "text/javascript">
	$(function(){
		PageLoad();
	});
</script>
EOM
print($out) or die($!);
$out = <<"EOM";
<div id = "topfloater">
<h1>SFS β8.1</h1>
<form name = "d" action = "./sfs.cgi" method = "POST">
<p>$fullpath&nbsp;
<input type = "radio" name = "d" value = "1" onClick = "submit()" $rdoDisplayMode1>アイコン表示
<input type = "radio" name = "d" value = "2" onClick = "submit()" $rdoDisplayMode2>リスト表示
&nbsp;
<a href = "./sfss.cgi">検索モード</a>
</p>
</form>
</div>
<div id = "main">
$bodyMsg
EOM
print($out) or die($!);;
# get files and directories.
my @all_files = glob('*');
foreach $file(@all_files){
	chomp($file);
	if(-d $file){
		chmod 0777, $file;
		my $dir = basename($file);
		push(@dirs, $file);
		#print(decode('UTF-8', 'directory : ' . $dir . '<br />'));
		if (!copy("./sfs.cgi", "$dir/")){
			print(decode('UTF-8', 'Failed to copy sfs.cgi : ' . $dir . '<br />'));
		}
		chmod 0775, "$dir/sfs.cgi";
		if (!copy("./sfss.cgi", "$dir/")){
			print(decode('UTF-8', 'Failed to copy sfss.cgi : ' . $dir . '<br />'));
		}
		chmod 0775, "$dir/sfss.cgi";
	}
	elsif((-f $file) and ($file !~ /^sfs.*\.cgi/)){
		push(@files, $file);
	}
}

# print directories and files.
print("<h2>ディレクトリ</h2>\n");
if($displayMode eq 1){
	$out = <<EOM;
<div class = "item"><div class = "misc"><a href = "../">dir</a></div><a href = "../">親ディレクトリ</a></div>
EOM
}
else{
	$out = <<EOM;
<ul>
<li><a href = "../">親ディレクトリ</a></li>
EOM
}
print($out);
foreach $dir(sort(@dirs)){
	my($basename, $dirname, $ext) = fileparse($dir, qr/\.^[\.]+$/);
	$basename = decode('UTF-8', $basename);
	my $iconTag = GetIconTag($basename, "dir");
	my $linkTag = GetLinkedTag($basename, "dir");
	my $listTag = GetListTag($basename, "dir");
	if($displayMode eq 1){
		$out = <<"EOM";
<div class = "item">${iconTag}${linkTag}</div>
EOM
	}
	else{
		$out = <<"EOM";
$listTag
EOM
	}
	print($out) or die($!);
}
if($displayMode eq 1){
	print('<br clear = "all" />' . "\n");
}
else{
	print("</ul>\n");
}
print("<h2>ファイル</h2>\n");
if($displayMode ne 1){
	print("<ul>\n");
}
foreach $file(sort(@files)){
	my($basename, $dirname, $ext) = fileparse($file, qr/\.[^\.]+$/);
	$basename = decode('UTF-8', $basename);
	my $iconTag = GetIconTag($basename . $ext, $ext);
	my $linkTag = GetLinkedTag($basename . $ext, $ext);
	my $listTag = GetListTag($basename . $ext, $ext);
	if($displayMode eq 1){
		$out = <<EOM;
<div class = "item">${iconTag}${linkTag}</div>
EOM
	}
	else{
		$out = <<EOM;
$listTag
EOM
	}
	print($out) or die($!);
}
if($displayMode eq 1){
	print('<br clear = "all" />' . "\n");
}
else{
	print("</ul>\n");
}
# print footer.

$out = <<"EOM";
</div>
<div id = "floater">
<div id = "statussection">
<div id = "msg">$err</div>
<form name = "form" action = "./sfs.cgi" method = "POST" enctype = "multipart/form-data">
<p>
<input type = "file" name = "upload" class = "btn" size = "100" multiple />
<button type = "submit" name = "submit" value = "upload" class = "btn">アップロード</button>
</p>
</form>
<form name = "form2" action = "./sfs.cgi" method = "POST">
<p>
<input type = "hidden" name = "status" id = "status" />
<button type = "submit" name = "submit" value = "rename" class = "btn" onclick = "return(RenameFile());">チェックしたファイルのリネーム</button>
<button type = "submit" name = "submit" value = "newdir" class = "btn" onclick = "return(NewDirectory());">ディレクトリ作成</button>
&nbsp;|&nbsp;
<button type = "submit" name = "submit" value = "delete" class = "btn" onclick = "return(DeleteFile());">チェックしたファイルを削除</button>
&nbsp;|&nbsp;
<button type = "submit" name = "submit" value = "download" class = "btn" onclick = "return(DownloadFile());">チェックしたファイルをダウンロード(使わないで!!)</button>
</p>
</form>
</div>
<div id = "curtain">
<a href = "#" onclick='CurtainUp()'>↑</a>
<a href = "#" onclick='CurtainDown()'>↓</a>
</div>
</div>
</body>
</html>
EOM
print($out) or die($!);

undef($q);

