#!/usr/bin/perl -w
# copyright(c)2018-2019 Kumeuchi Akira
use strict;
use utf8;
use CGI;
use URI;
use URI::Escape;
use File::Basename;
use File::Copy;
use File::Path;
use Encode;
use FindBin;
binmode STDOUT, ':utf8';

# setting.
my $msg = "";
my $sFiles = "";
my $imgsize = 120;
my $elapsedtime = 0.5;
my $err = "";
my $bodyMsg = "";
my $listWidth = 240;
my $listHeight = 20;

# initialization.
my $q = new CGI;
my $file = "";
my @files = ();
my $dir = "";
my @dirs = ();
my $out = "";
my $myURL = $q->url;
$myURL = URI->new_abs('.', $myURL);

# handy functions.
sub printenc($){
  print($_ . "\n");
}

sub GetParams(){
  if(!defined($_) or $_ eq ""){
    $msg .= "配列が定義されていません。\n";
    return;
  }
  my $item = $_;
  chomp($item);
  my @items = split(":", $item);
  return(@items);
}

#GET処理
my $searchText = "";
if($q->request_method eq "GET"){
  $searchText = $q->escapeHTML($q->param('text'));
	$searchText = decode('UTF-8', $searchText);
	#$searchText = uri_escape_utf8($searchText);
}
#ファイル探索
sub EnumFiles($$$@){
  my ($root, $dir, $text, @results) = @_;
	my $searchDir = $root . "/" . $dir;
	opendir(DIR, decode('UTF-8', $searchDir)) or die("Can not open directory : $dir\n");
	my @files = readdir(DIR) or die("Can not read files : @files\n");
	closedir(DIR);

  foreach $file(sort @files){
		next if($file =~ /^\.{1,2}$/);
		my $decFile = decode('UTF-8', $file);
		if(-d "$root/$dir/$file"){
			#print("Entering $decFile<br />\n");
			if("$dir/$decFile" =~ /$text/){
				push(@results, "$dir/$file");
			}
			@results = &EnumFiles($root, "$dir/$file", $text, @results);
		}
		#elsif(-f "$dir/$file"){
		else{
			#print("Checking $dir/$decFile<br />\n");
			if("$dir/$decFile" =~ /$text/){
				push(@results, "$dir/$file");
			}
		}
	}
  return @results;
}
# write header.
$out = <<"EOM";
Content-type: text/html

<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
		"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv = "Content-Type" content = "text/html; charset = utf-8" />
<title>SFSS</title>
<meta name = "Author" content = "Kumeuchi Akira" />
<meta name = "keywords" content = "SFS" />
<meta http-equiv = "Content-Style-Type" content = "text/css" />
<link href = "https://www.bass-world.net/styles.css" rel = "stylesheet" type = "text/css" media = "screen,tv" />
<style type = "text/css">
h1{margin: 8px 0px;}
p{margin: 8px;
  padding: 0px;
}
body{
	background-color: #ffffff;
}
.img{width: ${imgsize}px;}
div.item{width: ${imgsize}px; float: left; margin: 12px;}
div.misc{width: ${imgsize}px; height: ${imgsize}px; font-size: 36px; border-style: solid; border-width: 1px; border-color: #000000;}
div.itemlist{width: ${listWidth}px; height: ${listHeight}px; float: left; text-align: left; margin: 4px; border: 1px solid #eeeeee; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;}
.work_area{width: 100%; height: 50px;}
th{font-weight: normal; text-align: right; padding-right: 8px;}
.ok{background-color: #ffffff;}
.ng{background-color: #ffcccc;}
#floater{
	position: fixed;
	width: 100%;
	left: 0px;
	bottom: 0px;
	background-color: #000000;
	color: #ffffff;
}

#statussection{
	position: fixed;
	width: 100%;
	bottom: 0px;
	left: 0px;
	color: #ffffff;
	background-color: #000000;
}

#topfloater{
	position: fixed;
	width: 100%;
	top: 0px;
	background-color: #000000;
	color: #ffffff;
}
#topfloater h2,#topfloater h2 a:link,#topfloater h2 a:visited{color: #ffffff;}
#main{
	margin: 96px 0px 100px 0px;
	width: 100%;
}
EOM
print($out) or die($!);
print($out) or die($!);
$out = <<'EOM';
@media screen and (max-device-width:480px),screen and (max-width:480px){
	body{
		font-size: 2.5rem;
	}
	input[type=radio],input[type=checkbox]{
		font-size: 2.5rem;
		height: 30px;
		width: 30px;
	}
	div.itemlist{
		font-size: 1.4em;
		height: 1.6em;
		width: 95%;
	}
	div.item{
		font-sie: 1.4em;
	}
	#topfloater,#floater{
		position: static;
		margin: 0px;
		padding: 0px;
	}
	#floater,#floater input[type=button]{
		-webkit-appearance: none;
		font-size: 2.5rem;
		
	}
	#main{
		background-color: #ffffff;
	}
	#floater .btn{
		font-size: 2.5rem;
		height: 5rem;
		margin: 0.5rem;
	}
	#topfloater p{
		padding: 0px;
		margin: 0px;
	}
	#statussection{
		display: none;
	}
}
EOM
print($out) or die($!);
$out = <<'EOM';
</style>
<meta http-equiv = "Content-Script-Type" content = "text/javascript" />
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
EOM
print($out) or die($!);
$out = <<'EOM';
<body>
EOM
print($out) or die($!);

#my $fullpath = decode('UTF-8', uri_unescape($FindBin::Bin));
my $fullpath = uri_unescape($FindBin::Bin);
my $decFullPath = decode('UTF-8', $fullpath);

$out = <<"EOM";
<div id = "topfloater">
<h1>SFSS β1.1</h1>
<p>$decFullPath&nbsp;<a href="sfs.cgi">ブラウズモード</a></p>
</div>
<div id = "main">
$bodyMsg
EOM
print($out) or die($!);
# get files and directories.
$myURL = decode('UTF-8', uri_unescape($myURL));
print("<p>Search Text : $searchText in $myURL</p>\n") or die($!);
print("<ul>") or die($!);
my @result = ();
@result = EnumFiles($fullpath, '', $searchText, @result);
$myURL = substr($myURL, 0, -1);
foreach my $file(@result){
  my $basename = decode('UTF-8', $file);
  $out = <<"EOM";
  <li><a href = "${myURL}${basename}">${myURL}${basename}</a></li>
EOM
  print($out);
}
print("</ul>");

# print footer.
$out = <<"EOM";
</div>
<div id = "floater">
<form name = "form" action = "./sfss.cgi" method = "GET">
<p>
<input type = "text" name = "text" size = "40" />
<button type = "submit" name = "submit" value = "submit" class = "btn">検索</button>
</p>
</form>
</body>
</html>
EOM
print($out) or die($!);

undef($q);
